<?php
/**
 * onWebChat Settings Page with Tabs
 */

if (!defined('ABSPATH')) {
    exit;
}

function onwebchat_settings_page() {
    // Note: Form submissions are handled in admin_init hook (see onwebchat.php)
    // This ensures redirects happen before any output is sent
    
    // Get current tab
    $active_tab = isset($_GET['tab']) ? sanitize_text_field($_GET['tab']) : 'general';
    
    // Check connection status
    $options = get_option('onwebchat_plugin_option');
    $chatId = isset($options['text_string']) ? $options['text_string'] : '';
    $isConnected = !empty($chatId);
    
    ?>
    <div class="wrap">
        <h1 style="font-weight: 400; margin-top: 34px;">
            onWebChat <?php echo $isConnected ? 'Settings' : 'Activation'; ?>
        </h1>
        
        <?php if ($isConnected): ?>
        <!-- Tab Navigation (only show when connected) -->
        <h2 class="nav-tab-wrapper">
            <a href="?page=onwebchat_settings&tab=general" 
               class="nav-tab <?php echo $active_tab === 'general' ? 'nav-tab-active' : ''; ?>">
                General
            </a>
            
            <a href="?page=onwebchat_settings&tab=chat" 
               class="nav-tab <?php echo $active_tab === 'chat' ? 'nav-tab-active' : ''; ?>">
                Chat Widget
            </a>
            
            <?php if (class_exists('WooCommerce')): ?>
            <a href="?page=onwebchat_settings&tab=woocommerce" 
               class="nav-tab <?php echo $active_tab === 'woocommerce' ? 'nav-tab-active' : ''; ?>">
                WooCommerce
            </a>
            <?php endif; ?>
            
            <a href="?page=onwebchat_settings&tab=advanced" 
               class="nav-tab <?php echo $active_tab === 'advanced' ? 'nav-tab-active' : ''; ?>">
                Advanced
            </a>
        </h2>
        <?php endif; ?>
        
        <!-- Tab Content -->
        <div class="tab-content" style="margin-top: 20px;">
            <?php
            if (!$isConnected) {
                // Show connection tab if not connected
                require_once __DIR__ . '/tabs/general.php';
                onwebchat_general_tab($isConnected);
            } else {
                // Show appropriate tab based on selection
                switch ($active_tab) {
                    case 'chat':
                        require_once __DIR__ . '/tabs/chat.php';
                        onwebchat_chat_tab();
                        break;
                    
                    case 'woocommerce':
                        if (class_exists('WooCommerce')) {
                            require_once __DIR__ . '/tabs/woocommerce.php';
                            onwebchat_woocommerce_tab();
                        } else {
                            echo '<div class="notice notice-warning"><p>WooCommerce is not installed.</p></div>';
                        }
                        break;
                    
                    case 'advanced':
                        require_once __DIR__ . '/tabs/advanced.php';
                        onwebchat_advanced_tab();
                        break;
                    
                    default:
                        require_once __DIR__ . '/tabs/general.php';
                        onwebchat_general_tab($isConnected);
                }
            }
            ?>
        </div>
    </div>
    <?php
}

