<?php
/**
 * Advanced Tab - Custom JavaScript API
 */

if (!defined('ABSPATH')) {
    exit;
}

function onwebchat_advanced_tab() {
    
    // Handle form submissions
    onwebchat_handle_advanced_actions();
    
    $options = get_option('onwebchat_plugin_option');
    $chatId = isset($options['text_string']) ? $options['text_string'] : '';
    $onwebchatApi = get_option('onwebchat_plugin_option_api_code');
    $onwebchatApi = str_replace('\\', '', $onwebchatApi);
    
    ?>
    <form action="admin.php?page=onwebchat_settings&tab=advanced" method="post">
        <input type="hidden" name="action" value="save_advanced_settings">
        <input type="hidden" name="chatId" value="<?php echo esc_attr($chatId); ?>">
        <?php wp_nonce_field('on_web_chat_nonce'); ?>
        
        <h2>Advanced Settings</h2>
        <p>For advanced users. Add custom JavaScript to extend onWebChat functionality.</p>
        
        <table class="form-table">
            <tr>
                <th scope="row">
                    <label for="onwebchat-api">Custom JavaScript API</label>
                </th>
                <td>
                    <textarea id="onwebchat-api" name="onwebchat-api" rows="12" class="large-text code"><?php echo esc_html($onwebchatApi); ?></textarea>
                    <p class="description">
                        Add custom JavaScript code to interact with the onWebChat API.<br>
                        Example: <code>onWebChat.set('name', 'John Doe');</code><br>
                        <a href="https://www.onwebchat.com/live-chat-api.php" target="_blank">View API Documentation</a>
                    </p>
                </td>
            </tr>
        </table>
        
        <div class="notice notice-info inline">
            <p>
                <strong>Note:</strong> Only add code here if you know what you're doing. 
                Incorrect JavaScript may break the chat widget.
            </p>
        </div>
        
        <p class="submit">
            <input type="submit" class="button button-primary" value="Save Advanced Settings">
        </p>
    </form>
    <?php
}

/**
 * Handle form submissions for advanced tab
 */
function onwebchat_handle_advanced_actions() {
    
    if (isset($_POST["action"]) && $_POST["action"] == "save_advanced_settings") {
        
        if (!isset($_POST['_wpnonce']) || !wp_verify_nonce($_POST['_wpnonce'], 'on_web_chat_nonce')) {
            wp_die('Sorry, your nonce did not verify.');
        }
        
        if (!current_user_can('manage_options')) {
            wp_die('Insufficient permissions.');
        }
        
        $onwebchatApi = isset($_POST["onwebchat-api"]) ? wp_kses_post($_POST["onwebchat-api"]) : '';
        
        update_option('onwebchat_plugin_option_api_code', $onwebchatApi);
        
        echo '<div class="notice notice-success"><p>Advanced settings saved successfully!</p></div>';
    }
}

