<?php
/**
 * Chat Widget Tab - Display & Visibility Settings
 */

if (!defined('ABSPATH')) {
    exit;
}

function onwebchat_chat_tab() {
    
    // Handle form submissions
    onwebchat_handle_chat_actions();
    
    $options = get_option('onwebchat_plugin_option');
    $chatId = isset($options['text_string']) ? $options['text_string'] : '';
    $pagesSelect = get_option('onwebchat_plugin_option_pages_select', 1);
    
    ?>
    <form action="admin.php?page=onwebchat_settings&tab=chat" method="post">
        <input type="hidden" name="action" value="save_chat_settings">
        <input type="hidden" name="chatId" value="<?php echo esc_attr($chatId); ?>">
        <?php wp_nonce_field('on_web_chat_nonce'); ?>
        
        <h2>Chat Widget Visibility</h2>
        <p>Control where the chat widget appears on your website.</p>
        
        <table class="form-table">
            <tr>
                <th scope="row">
                    <label for="pages-select">Display Options</label>
                </th>
                <td>
                    <select id="pages-select" name="pages-select" onchange="onwc_select_change()" style="width: 400px;">
                        <option value="1" <?php selected($pagesSelect, 1); ?>>
                            Show the chat widget on all pages
                        </option>
                        <option value="2" <?php selected($pagesSelect, 2); ?>>
                            Show the chat widget only on selected pages
                        </option>
                        <option value="3" <?php selected($pagesSelect, 3); ?>>
                            Hide the chat widget on selected pages
                        </option>
                        <option value="4" <?php selected($pagesSelect, 4); ?>>
                            Hide the chat widget on all pages
                        </option>
                    </select>
                </td>
            </tr>
            
            <tr id="onwc_show_on_pages_row" style="display:none;">
                <th scope="row">
                    <label for="showonpages">Show Only On</label>
                </th>
                <td>
                    <input id="showonpages" name="showonpages" type="text" class="regular-text"
                           value="<?php echo esc_attr(get_option('onwebchat_plugin_option_show_pages')); ?>" />
                    <p class="description">
                        Add multiple pages by separating them with a space. You can enter a full URL or just part of it.<br>
                        Example: <code>index price contact.php blog/</code>
                    </p>
                </td>
            </tr>
            
            <tr id="onwc_hide_on_pages_row" style="display:none;">
                <th scope="row">
                    <label for="hideonpages">Hide On</label>
                </th>
                <td>
                    <input id="hideonpages" name="hideonpages" type="text" class="regular-text"
                           value="<?php echo esc_attr(get_option('onwebchat_plugin_option_hide_pages')); ?>" />
                    <p class="description">
                        Add multiple pages by separating them with a space. You can enter a full URL or just part of it.<br>
                        Example: <code>index price contact.php blog/</code>
                    </p>
                </td>
            </tr>
        </table>
        
        <p class="submit">
            <input type="submit" class="button button-primary" value="Save Chat Settings">
        </p>
    </form>
    
    <script type="text/javascript">
    function onwc_select_change() {
        var e = document.getElementById("pages-select");
        if (!e) return;
        
        var selected = e.options[e.selectedIndex].value;
        var showRow = document.getElementById("onwc_show_on_pages_row");
        var hideRow = document.getElementById("onwc_hide_on_pages_row");
        
        showRow.style.display = "none";
        hideRow.style.display = "none";
        
        if (selected == 2) {
            showRow.style.display = "table-row";
        } else if (selected == 3) {
            hideRow.style.display = "table-row";
        }
    }
    
    // Run on page load
    document.addEventListener('DOMContentLoaded', function() {
        onwc_select_change();
    });
    </script>
    <?php
}

/**
 * Handle form submissions for chat tab
 */
function onwebchat_handle_chat_actions() {
    
    if (isset($_POST["action"]) && $_POST["action"] == "save_chat_settings") {
        
        if (!isset($_POST['_wpnonce']) || !wp_verify_nonce($_POST['_wpnonce'], 'on_web_chat_nonce')) {
            wp_die('Sorry, your nonce did not verify.');
        }
        
        if (!current_user_can('manage_options')) {
            wp_die('Insufficient permissions.');
        }
        
        $pagesSelect = isset($_POST["pages-select"]) ? absint($_POST["pages-select"]) : 1;
        $showOnPages = isset($_POST["showonpages"]) ? sanitize_text_field($_POST["showonpages"]) : '';
        $hideOnPages = isset($_POST["hideonpages"]) ? sanitize_text_field($_POST["hideonpages"]) : '';
        
        update_option('onwebchat_plugin_option_pages_select', $pagesSelect);
        
        if ($pagesSelect == 2) {
            update_option('onwebchat_plugin_option_show_pages', $showOnPages);
        } else if ($pagesSelect == 3) {
            update_option('onwebchat_plugin_option_hide_pages', $hideOnPages);
        }
        
        echo '<div class="notice notice-success"><p>Chat settings saved successfully!</p></div>';
    }
}

