<?php
/**
 * General Tab - Account Connection
 */

if (!defined('ABSPATH')) {
    exit;
}

function onwebchat_general_tab($isConnected = false) {
    
    // Note: Form submissions are handled in admin_init hook (see onwebchat.php)
    // This ensures redirects happen before any WordPress admin output
    
    $options = get_option('onwebchat_plugin_option');
    $chatId = isset($options['text_string']) ? $options['text_string'] : '';
    
    ?>
    
    <?php if (!$isConnected): ?>
        <!-- Not Connected - Show Login Form -->
        <h2>Connect Your Account</h2>
        <p>Link your WordPress site to your onWebChat account to enable the live chat widget and AI features.</p>
        
        <form action="admin.php?page=onwebchat_settings&tab=general" method="post">
            <input type="hidden" name="action" value="login">
            <?php wp_nonce_field('on_web_chat_nonce'); ?>
            
            <!-- Option 1: Email/Password Login -->
            <div class="card" style="max-width: 600px; margin: 20px 0; padding: 20px; background: #fff; border: 1px solid #c3c4c7; box-shadow: 0 1px 1px rgba(0,0,0,.04);">
                <h3 style="margin-top: 0; display: flex; align-items: center; gap: 8px;">
                    <span style="background: #2271b1; color: #fff; width: 24px; height: 24px; border-radius: 50%; display: inline-flex; align-items: center; justify-content: center; font-size: 14px;">1</span>
                    Login with Email & Password
                </h3>
                <p style="color: #646970; margin-bottom: 15px;">
                    Recommended — enables automatic WooCommerce sync connection.
                </p>
                
                <table class="form-table" style="margin: 0;">
                    <tr>
                        <th scope="row" style="width: 100px; padding: 10px 10px 10px 0;">
                            <label for="onWebChatUser">Email</label>
                        </th>
                        <td style="padding: 10px 0;">
                            <input type="email" 
                                   id="onWebChatUser"
                                   name="onWebChatUser" 
                                   class="regular-text"
                                   placeholder="your@email.com"
                                   value="<?php echo esc_attr(get_option('onwebchat_plugin_option_user')); ?>">
                        </td>
                    </tr>
                    <tr>
                        <th scope="row" style="width: 100px; padding: 10px 10px 10px 0;">
                            <label for="onWebChatPass">Password</label>
                        </th>
                        <td style="padding: 10px 0;">
                            <input type="password" 
                                   id="onWebChatPass"
                                   name="onWebChatPass" 
                                   class="regular-text"
                                   placeholder="Your onWebChat password">
                        </td>
                    </tr>
                </table>
            </div>
            
            <!-- Divider -->
            <div style="max-width: 600px; display: flex; align-items: center; margin: 25px 0;">
                <div style="flex: 1; height: 1px; background: #c3c4c7;"></div>
                <span style="padding: 0 20px; color: #646970; font-size: 14px; font-weight: 500;">OR</span>
                <div style="flex: 1; height: 1px; background: #c3c4c7;"></div>
            </div>
            
            <!-- Option 2: Chat ID -->
            <div class="card" style="max-width: 600px; margin: 20px 0; padding: 20px; background: #fff; border: 1px solid #c3c4c7; box-shadow: 0 1px 1px rgba(0,0,0,.04);">
                <h3 style="margin-top: 0; display: flex; align-items: center; gap: 8px;">
                    <span style="background: #646970; color: #fff; width: 24px; height: 24px; border-radius: 50%; display: inline-flex; align-items: center; justify-content: center; font-size: 14px;">2</span>
                    Use Chat ID Only
                </h3>
                <p style="color: #646970; margin-bottom: 15px;">
                    Quick setup — paste your Chat ID from your onWebChat dashboard.
                </p>
                
                <table class="form-table" style="margin: 0;">
                    <tr>
                        <th scope="row" style="width: 100px; padding: 10px 10px 10px 0;">
                            <label for="chatId">Chat ID</label>
                        </th>
                        <td style="padding: 10px 0;">
                            <input type="text" 
                                   id="chatId"
                                   name="chatId" 
                                   class="regular-text"
                                   placeholder="e.g. 3a02c87b60726a4663b25463a424a248"
                                   value="<?php echo esc_attr($chatId); ?>">
                            <p class="description">Found in your onWebChat Dashboard → Settings → Installation</p>
                        </td>
                    </tr>
                </table>
            </div>
            
            <!-- Submit Button -->
            <p style="margin-top: 20px;">
                <button type="submit" class="button button-primary button-hero">
                    Connect Account
                </button>
            </p>
            
            <!-- New Account Link -->
            <p style="margin-top: 15px; color: #646970;">
                Don't have an onWebChat account yet? 
                <a href="https://www.onwebchat.com/signup.php" target="_blank">Create one here</a> to get started.
            </p>
        </form>
        
    <?php else: ?>
        <!-- Connected Status -->
        <h2>Account Connected</h2>
        
        <p style="color: #646970; margin: 10px 0 20px 0;">
            <?php
            $userOption = get_option('onwebchat_plugin_option_user');
            if (!empty($userOption)) {
                echo '<span style="color: #2271b1;">✓</span> <strong>Connected as:</strong> ' . esc_html($userOption);
            } else {
                $chatIdOption = get_option('onwebchat_plugin_option');
                $displayChatId = isset($chatIdOption['text_string']) ? $chatIdOption['text_string'] : '';
                echo '<span style="color: #2271b1;">✓</span> <strong>Connected with Chat ID:</strong> <code>' . esc_html($displayChatId) . '</code>';
            }
            ?>
        </p>
        
        <div class="card" style="max-width: 600px; margin: 20px 0; padding: 20px; background: #fff; border: 1px solid #c3c4c7; box-shadow: 0 1px 1px rgba(0,0,0,.04);">
            <h3 style="margin-top: 0;">Quick Actions</h3>
            
            <p>
                <a href="https://www.onwebchat.com/login.php" target="_blank" class="button button-secondary">
                    Open onWebChat Dashboard →
                </a>
            </p>
            
            <hr style="margin: 20px 0; border: none; border-top: 1px solid #c3c4c7;">
            
            <p style="margin-bottom: 0;">
                <a href="admin.php?page=onwebchat_settings&tab=general&action=deactivate" 
                   style="color: #b32d2e; text-decoration: none;"
                   onclick="return confirm('Are you sure you want to unlink your account? The chat widget will be removed from your site.');">
                    Unlink Account
                </a>
                <span style="color: #646970; margin-left: 5px;">— Disconnect this WordPress site from onWebChat</span>
            </p>
        </div>
        
    <?php endif; ?>
    <?php
}

/**
 * Handle form submissions for general tab
 */
function onwebchat_handle_general_actions() {
    
    // Handle login/connection
    if (isset($_POST["action"]) && $_POST["action"] == "login") {
        
        if (!isset($_POST['_wpnonce']) || !wp_verify_nonce($_POST['_wpnonce'], 'on_web_chat_nonce')) {
            wp_die('Sorry, your nonce did not verify.');
        }
        
        $userName = isset($_POST["onWebChatUser"]) ? sanitize_text_field($_POST["onWebChatUser"]) : '';
        $userPass = isset($_POST["onWebChatPass"]) ? sanitize_text_field($_POST["onWebChatPass"]) : '';
        $chatId = isset($_POST["chatId"]) ? sanitize_text_field($_POST["chatId"]) : '';
        
        if (isChatIdValid($chatId)) {
            // Direct Chat ID provided
            $my_options = get_option('onwebchat_plugin_option');
            $my_options['text_string'] = $chatId;
            update_option('onwebchat_plugin_option', $my_options);
            update_option('onwebchat_plugin_option_user', '');
            update_option('onwebchat_plugin_option_pages_select', 1);
            
            wp_redirect(admin_url('admin.php?page=onwebchat_settings&tab=general'));
            exit;
            
        } else {
            // Try to get Chat ID from server
            update_option('onwebchat_plugin_option_user', $userName);
            
            $response = wp_remote_post(ONWEBCHAT_SERVER_URL, array(
                'method' => 'POST',
                'timeout' => 45,
                'body' => array('email' => $userName, 'pass' => $userPass),
            ));
            
            if (!is_wp_error($response) && !empty($response['body'])) {
                $my_options = get_option('onwebchat_plugin_option');
                $my_options['text_string'] = $response['body'];
                update_option('onwebchat_plugin_option', $my_options);
                update_option('onwebchat_plugin_option_pages_select', 1);
                
                // Also fetch WooCommerce secret with same credentials
                // This way user doesn't need to re-enter credentials in WooCommerce tab
                onwebchat_fetch_wc_secret_on_login($userName, $userPass, $response['body']);
                
                wp_redirect(admin_url('admin.php?page=onwebchat_settings&tab=general'));
                exit;
            } else {
                onwebchat_login_error(true);
            }
        }
    }
    
    // Handle disconnect
    if (isset($_GET["action"]) && $_GET["action"] == "deactivate") {
        $my_options = get_option('onwebchat_plugin_option');
        $my_options['text_string'] = '';
        update_option('onwebchat_plugin_option', $my_options);
        update_option('onwebchat_plugin_option_pages_select', 1);
        
        wp_redirect(admin_url('admin.php?page=onwebchat_settings&tab=general'));
        exit;
    }
}
