<?php
/**
 * WooCommerce Tab - Product Sync Settings
 */

if (!defined('ABSPATH')) {
    exit;
}

function onwebchat_woocommerce_tab() {
    
    // Handle form submissions
    onwebchat_handle_woocommerce_actions();
    
    // Get current settings
    $sync_enabled = get_option('onwebchat_wc_sync_enabled', false);
    $sync_mode = get_option('onwebchat_wc_sync_mode', 'short_fallback_full');
    $include_price = get_option('onwebchat_wc_sync_include_price', false);
    $secret = get_option('onwebchat_wc_sync_secret', '');
    
    // Get sync status
    $sync_status = array(
        'last_sync' => get_option('onwebchat_wc_last_bulk_sync', 0),
        'in_progress' => get_option('onwebchat_wc_bulk_in_progress', false),
        'done' => get_option('onwebchat_wc_bulk_done', 0),
        'total' => get_option('onwebchat_wc_bulk_total', 0),
        'last_sync_start' => get_option('onwebchat_wc_last_sync_start', 0),
    );
    
    // Calculate cooldown status
    $cooldown_period = 5 * 60; // 5 minutes // 5min // 5 * 60    //also in the file woocommerce-sync.php 
    $time_since_last_sync = time() - $sync_status['last_sync_start'];
    $is_in_cooldown = ($time_since_last_sync < $cooldown_period) && $sync_status['last_sync_start'] > 0;
    $cooldown_remaining = $is_in_cooldown ? ceil(($cooldown_period - $time_since_last_sync) / 60) : 0;
    
    ?>
    
    <?php if (isset($_GET['wc_saved']) && $_GET['wc_saved'] == '1'): ?>
        <div class="notice notice-success is-dismissible">
            <p><strong>WooCommerce settings saved successfully!</strong></p>
        </div>
    <?php endif; ?>
    
    <h2>WooCommerce Product Sync</h2>
    <p>
        Let your AI chatbot understand your WooCommerce products. 
        When enabled, products are automatically synced and kept up to date, allowing the AI to answer product-related questions accurately.
    </p>
    
    <?php if (empty($secret)): ?>
    <!-- Authentication required section -->
    <div class="notice notice-warning" style="margin: 15px 0; padding: 15px;">
        <h3 style="margin-top: 0;">🔐 Connect WooCommerce Sync</h3>
        <p>
            To enable WooCommerce sync, please enter your onWebChat account credentials below.
        </p>
        <p style="color: #666; font-size: 13px;">
            <!-- <strong>💡 Tip:</strong> If you originally connected using email/password in the <a href="?page=onwebchat_settings&tab=general">General tab</a>, 
            try unlinking and re-linking your account there. WooCommerce sync will be connected automatically! -->
        </p>
        
        <table class="form-table" style="margin-bottom: 0;">
            <tr>
                <th scope="row"><label for="onwebchat_wc_email">Email</label></th>
                <td>
                    <input type="email" 
                           id="onwebchat_wc_email" 
                           class="regular-text" 
                           placeholder="your@email.com"
                           value="<?php echo esc_attr(get_option('onwebchat_plugin_option_user', '')); ?>">
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="onwebchat_wc_password">Password</label></th>
                <td>
                    <input type="password" 
                           id="onwebchat_wc_password" 
                           class="regular-text" 
                           placeholder="Your onWebChat password">
                </td>
            </tr>
        </table>
        
        <p style="margin-top: 15px;">
            <button type="button" id="onwebchat_wc_connect" class="button button-primary">
                Connect WooCommerce Sync
            </button>
            <span id="onwebchat_wc_connect_status" style="margin-left: 10px;"></span>
        </p>
    </div>
    
    <script type="text/javascript">
    jQuery(document).ready(function($) {
        $('#onwebchat_wc_connect').on('click', function() {
            var email = $('#onwebchat_wc_email').val();
            var password = $('#onwebchat_wc_password').val();
            
            if (!email || !password) {
                alert('Please enter both email and password.');
                return;
            }
            
            var $btn = $(this);
            var $status = $('#onwebchat_wc_connect_status');
            
            $btn.prop('disabled', true).text('Connecting...');
            $status.html('');
            
            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'onwebchat_wc_connect',
                    email: email,
                    password: password,
                    nonce: '<?php echo wp_create_nonce('onwebchat_wc_sync_nonce'); ?>'
                },
                success: function(response) {
                    if (response.success) {
                        $status.html('<span style="color: green;">✓ Connected successfully!</span>');
                        setTimeout(function() {
                            location.reload();
                        }, 1000);
                    } else {
                        $status.html('<span style="color: red;">✗ ' + response.data + '</span>');
                        $btn.prop('disabled', false).text('Connect WooCommerce Sync');
                    }
                },
                error: function() {
                    $status.html('<span style="color: red;">✗ Connection error. Please try again.</span>');
                    $btn.prop('disabled', false).text('Connect WooCommerce Sync');
                }
            });
        });
    });
    </script>
    
    <?php else: ?>
    <!-- Connected - show settings -->
    
    <form action="admin.php?page=onwebchat_settings&tab=woocommerce" method="post">
        <input type="hidden" name="action" value="save_wc_sync">
        <?php wp_nonce_field('onwebchat_wc_sync_nonce'); ?>
        
        <table class="form-table">
            <tr>
                <th scope="row">
                    <label for="onwebchat_wc_sync_enabled">Enable Product Sync</label>
                </th>
                <td>
                    <label for="onwebchat_wc_sync_enabled">
                        <input type="checkbox" 
                               id="onwebchat_wc_sync_enabled" 
                               name="onwebchat_wc_sync_enabled" 
                               value="1" 
                               <?php checked($sync_enabled, true); ?>>
                        Automatically sync products to onWebChat for AI training
                    </label>
                    <p id="onwebchat_wc_sync_status" style="margin: 8px 0 0 0; font-size: 13px; min-height: 20px; display: none;">
                    </p>
                </td>
            </tr>
            
            <tr style="display: none;">
                <th scope="row">
                    <label for="onwebchat_wc_sync_mode">Description Mode</label>
                </th>
                <td>
                    <select id="onwebchat_wc_sync_mode" name="onwebchat_wc_sync_mode" style="width: 350px;">
                        <option value="short_only" <?php selected($sync_mode, 'short_only'); ?>>
                            Short description only
                        </option>
                        <option value="short_fallback_full" <?php selected($sync_mode, 'short_fallback_full'); ?>>
                            Short description (fallback to full)
                        </option>
                    </select>
                    <p class="description">
                        Choose how product descriptions are synced for AI training
                    </p>
                </td>
            </tr>
            
            <tr style="display: none">
                <th scope="row">
                    <label for="onwebchat_wc_sync_include_price">Include Pricing</label>
                </th>
                <td>
                    <label for="onwebchat_wc_sync_include_price">
                        <input type="checkbox" 
                               id="onwebchat_wc_sync_include_price" 
                               name="onwebchat_wc_sync_include_price" 
                               value="1" 
                               <?php checked($include_price, true); ?>>
                        Include product prices in sync data
                    </label>
                </td>
            </tr>
            
            
            <?php if (!empty($secret)): ?>
            <tr style="display: none;">
                <th scope="row">Connection Status</th>
                <td>
                    <span style="color: green; font-weight: bold;">✓ Connected</span>
                    <code style="background: #f5f5f5; padding: 8px 12px; border-radius: 4px; display: inline-block; font-size: 11px; margin-left: 10px;">
                        <?php echo esc_html(substr($secret, 0, 8) . '...' . substr($secret, -4)); ?>
                    </code>
                    <button type="button" 
                            id="onwebchat_regenerate_secret" 
                            class="button" 
                            style="margin-left: 10px;">
                        Disconnect & Reconnect
                    </button>
                    <p class="description">
                        WooCommerce sync is securely connected. Click "Disconnect & Reconnect" to re-authenticate.
                    </p>
                </td>
            </tr>
            <?php endif; ?>
        </table>
    </form>
    
    <hr>
    
    <h2>Bulk Sync Status</h2>
    
    <div id="onwebchat_sync_status_display" style="background: #f9f9f9; padding: 20px; border-radius: 8px; max-width: 800px; margin-top: 15px;">
        <?php if ($sync_status['in_progress']): ?>
            <p style="margin: 0 0 10px 0;">
                <strong>⏳ Sync in progress:</strong> 
                <?php echo esc_html($sync_status['done']); ?> / <?php echo esc_html($sync_status['total']); ?> products synced
            </p>
            <div style="background: #fff; border: 1px solid #ddd; border-radius: 4px; height: 20px; overflow: hidden;">
                <div style="background: #2271b1; height: 100%; width: <?php echo $sync_status['total'] > 0 ? ($sync_status['done'] / $sync_status['total'] * 100) : 0; ?>%; transition: width 0.3s;"></div>
            </div>
        <?php elseif ($sync_status['last_sync'] > 0): ?>
            <p id="onwebchat_last_sync_info" style="margin: 0;">
                <strong>✓ Last bulk sync:</strong> 
                <?php echo esc_html(human_time_diff($sync_status['last_sync'], current_time('timestamp')) . ' ago'); ?>
            </p>
            <p id="onwebchat_total_synced_info" style="margin: 10px 0 0 0; color: #666;">
                Total products synced: <?php echo esc_html($sync_status['total']); ?>
            </p>
        <?php else: ?>
            <p style="margin: 0; color: #666;">
                No bulk sync has been performed yet.
            </p>
        <?php endif; ?>
        
        <?php if (!$is_in_cooldown): ?>
        <p style="margin-top: 15px;">
            <button type="button" 
                    id="onwebchat_sync_now" 
                    class="button button-primary" 
                    <?php echo $sync_status['in_progress'] ? 'disabled' : ''; ?>>
                <?php echo $sync_status['in_progress'] ? 'Sync in Progress...' : 'Sync All Products Now'; ?>
            </button>
        </p>
        <?php endif; ?>
        
        <p class="description onwebchat-sync-description" style="margin-top: 10px;">
            <?php if ($is_in_cooldown): ?>
                <?php if ($sync_enabled): ?>
                    Bulk sync was completed recently. Your products are already up to date, and any new or updated products will be synced automatically.
                <?php else: ?>
                    Bulk sync was completed recently. Your products are already up to date. Please enable "Automatically sync products to onWebChat for AI training" above to keep all your products synced automatically.
                <?php endif; ?>
            <?php else: ?>
                Click to sync all existing products. This process runs in the background and may take several minutes depending on your product count.
            <?php endif; ?>
        </p>
        
        <?php 
        // Show reset button if sync appears stuck (done >= total OR in progress for more than 3 minutes)
        $stuck_sync = $sync_status['in_progress'] && (
            $sync_status['done'] >= $sync_status['total'] || 
            (time() - $sync_status['last_sync_start'] > 180)
        );
        if ($stuck_sync): 
        ?>
            <p style="margin-top: 10px;">
                <button type="button" 
                        id="onwebchat_manual_process_batch" 
                        class="button button-secondary"
                        style="margin-right: 10px;">
                    Process Batch Manually
                </button>
                <button type="button" 
                        id="onwebchat_reset_sync_status" 
                        class="button">
                    Mark Sync as Complete
                </button>
                <span class="description" style="margin-left: 10px;">
                    If sync appears stuck, try processing manually or reset status.
                </span>
            </p>
        <?php endif; ?>
    </div>
    
    <script type="text/javascript">
    jQuery(document).ready(function($) {
        // Cooldown timer - reload page when cooldown expires
        <?php if ($is_in_cooldown): ?>
        var cooldownSeconds = <?php echo ($cooldown_period - $time_since_last_sync); ?>;
        setTimeout(function() {
            location.reload();
        }, cooldownSeconds * 1000);
        <?php endif; ?>
        
        // Sync enabled checkbox - save immediately via AJAX
        $('#onwebchat_wc_sync_enabled').on('change', function() {
            var $checkbox = $(this);
            var $status = $('#onwebchat_wc_sync_status');
            var $syncDescription = $('.onwebchat-sync-description');
            var isEnabled = $checkbox.is(':checked');
            
            // Disable checkbox while saving
            $checkbox.prop('disabled', true);
            
            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'onwebchat_wc_save_sync_enabled',
                    sync_enabled: isEnabled ? '1' : '0',
                    nonce: '<?php echo wp_create_nonce('onwebchat_wc_sync_nonce'); ?>'
                },
                success: function(response) {
                    if (response.success) {
                        if (response.data.enabled) {
                            $status.html('<span style="color: green;">✅ WooCommerce product sync enabled</span>');
                            // Update the sync description text if in cooldown
                            if ($syncDescription.length) {
                                var currentText = $syncDescription.text().trim();
                                if (currentText.includes('Bulk sync was completed recently')) {
                                    $syncDescription.text('Bulk sync was completed recently. Your products are already up to date, and any new or updated products will be synced automatically.');
                                }
                            }
                        } else {
                            $status.html('<span style="color: #d63638;">❌ WooCommerce product sync disabled</span>');
                            // Update the sync description text if in cooldown
                            if ($syncDescription.length) {
                                var currentText = $syncDescription.text().trim();
                                if (currentText.includes('Bulk sync was completed recently')) {
                                    $syncDescription.text('Bulk sync was completed recently. Your products are already up to date. Please enable "Automatically sync products to onWebChat for AI training" above to keep all your products synced automatically.');
                                }
                            }
                        }
                        // Ensure status is visible and fade in smoothly
                        $status.css('display', 'block').css('opacity', 1).css('visibility', 'visible');
                        // Hide it after 2.5 seconds with fade out
                        setTimeout(function() {
                            $status.animate({opacity: 0}, 300, function() {
                                $status.css('display', 'none');
                            });
                        }, 1700);
                    } else {
                        // Revert checkbox on error
                        $checkbox.prop('checked', !isEnabled);
                        alert('Error: ' + (response.data || 'Failed to save setting'));
                    }
                    $checkbox.prop('disabled', false);
                },
                error: function() {
                    // Revert checkbox on error
                    $checkbox.prop('checked', !isEnabled);
                    alert('An error occurred. Please try again.');
                    $checkbox.prop('disabled', false);
                }
            });
        });
        
        // Sync now button
        $('#onwebchat_sync_now').on('click', function() {
            if ($(this).prop('disabled')) {
                return;
            }
            
            if (!confirm('Sync all published products with onWebChat to train your AI chatbot?')) {
                return;
            }
            
            var $btn = $(this);
            $btn.prop('disabled', true).text('Syncing products...');
            
            // Hide the "Last sync" info while syncing
            $('#onwebchat_last_sync_info').hide();
            $('#onwebchat_total_synced_info').hide();
            
            // Show initial syncing message with progress bar
            $('#onwebchat_sync_status_display').html(
                '<p style="margin: 0 0 10px 0;"><strong>⏳ Sync in progress:</strong> <span id="sync_progress_text">0 / ? products synced</span></p>' +
                '<div style="background: #fff; border: 1px solid #ddd; border-radius: 4px; height: 20px; overflow: hidden;">' +
                    '<div id="sync_progress_bar" style="background: #2271b1; height: 100%; width: 0%; transition: width 0.3s;"></div>' +
                '</div>' +
                '<p style="margin: 10px 0 0 0; color: #666;">Please wait, this may take several minutes.</p>'
            );
            
            // Start polling for progress updates
            var progressInterval = setInterval(function() {
                $.ajax({
                    url: ajaxurl,
                    type: 'POST',
                    data: {
                        action: 'onwebchat_wc_get_sync_status',
                        nonce: '<?php echo wp_create_nonce('onwebchat_wc_sync_nonce'); ?>'
                    },
                    success: function(statusResponse) {
                        if (statusResponse.success && statusResponse.data.in_progress) {
                            var done = statusResponse.data.done || 0;
                            var total = statusResponse.data.total || 0;
                            var percentage = total > 0 ? Math.round((done / total) * 100) : 0;
                            
                            $('#sync_progress_text').text(done + ' / ' + total + ' products synced');
                            $('#sync_progress_bar').css('width', percentage + '%');
                        }
                    }
                });
            }, 2000); // Poll every 2 seconds
            
            $.ajax({
                url: ajaxurl,
                type: 'POST',
                timeout: 120000, // 2 minute timeout for large syncs
                data: {
                    action: 'onwebchat_wc_sync_now',
                    nonce: '<?php echo wp_create_nonce('onwebchat_wc_sync_nonce'); ?>'
                },
                success: function(response) {
                    clearInterval(progressInterval); // Stop polling
                    
                    if (response.success) {
                        var result = response.data.result;
                        var stats = result.stats;
                        var msg = 'Sync completed!\n\n' +
                            'Products processed: ' + result.done + '/' + response.data.total + '\n' +
                            'Created: ' + stats.created + '\n' +
                            'Updated: ' + stats.updated + '\n' +
                            'Unchanged: ' + stats.skipped + '\n' +
                            'Errors: ' + stats.errors;
                        alert(msg);
                        location.reload();
                    } else {
                        alert('Error: ' + response.data);
                        $btn.prop('disabled', false).text('Sync All Products Now');
                    }
                },
                error: function(xhr, status, error) {
                    clearInterval(progressInterval); // Stop polling
                    alert('An error occurred: ' + error + '. Please try again.');
                    $btn.prop('disabled', false).text('Sync All Products Now');
                }
            });
        });
        
        // Manual process batch button (for debugging stuck syncs)
        $('#onwebchat_manual_process_batch').on('click', function() {
            var $btn = $(this);
            $btn.prop('disabled', true).text('Processing...');
            
            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'onwebchat_wc_manual_process_batch',
                    nonce: '<?php echo wp_create_nonce('onwebchat_wc_sync_nonce'); ?>'
                },
                success: function(response) {
                    if (response.success) {
                        alert('Batch processed. Check console/logs for details.');
                        location.reload();
                    } else {
                        alert('Error: ' + response.data);
                        $btn.prop('disabled', false).text('Process Batch Manually');
                    }
                },
                error: function() {
                    alert('An error occurred. Please try again.');
                    $btn.prop('disabled', false).text('Process Batch Manually');
                }
            });
        });
        
        // Reset sync status button
        $('#onwebchat_reset_sync_status').on('click', function() {
            if (!confirm('Mark sync as complete? This will reset the progress indicator.')) {
                return;
            }
            
            var $btn = $(this);
            $btn.prop('disabled', true).text('Resetting...');
            
            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'onwebchat_wc_reset_sync_status',
                    nonce: '<?php echo wp_create_nonce('onwebchat_wc_sync_nonce'); ?>'
                },
                success: function(response) {
                    if (response.success) {
                        location.reload();
                    } else {
                        alert('Error: ' + response.data);
                        $btn.prop('disabled', false).text('Mark Sync as Complete');
                    }
                },
                error: function() {
                    alert('An error occurred. Please try again.');
                    $btn.prop('disabled', false).text('Mark Sync as Complete');
                }
            });
        });
        
        // Regenerate secret button (now "Disconnect" button)
        $('#onwebchat_regenerate_secret').on('click', function() {
            if (!confirm('This will disconnect WooCommerce sync. You will need to re-authenticate with your credentials. Continue?')) {
                return;
            }
            
            var $btn = $(this);
            $btn.prop('disabled', true).text('Disconnecting...');
            
            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'onwebchat_wc_regenerate_secret',
                    nonce: '<?php echo wp_create_nonce('onwebchat_wc_sync_nonce'); ?>'
                },
                success: function(response) {
                    if (response.success) {
                        alert('WooCommerce sync disconnected. Please re-authenticate to continue syncing.');
                        location.reload();
                    } else {
                        alert('Error: ' + response.data);
                        $btn.prop('disabled', false).text('Disconnect & Reconnect');
                    }
                },
                error: function() {
                    alert('An error occurred. Please try again.');
                    $btn.prop('disabled', false).text('Disconnect & Reconnect');
                }
            });
        });
    });
    </script>
    
    <?php endif; // End if secret exists ?>
    
    <?php
}

/**
 * Handle form submissions for WooCommerce tab
 */
function onwebchat_handle_woocommerce_actions() {
    
    if (isset($_POST["action"]) && $_POST["action"] == "save_wc_sync") {
        
        if (!isset($_POST['_wpnonce']) || !wp_verify_nonce($_POST['_wpnonce'], 'onwebchat_wc_sync_nonce')) {
            wp_die('Sorry, your nonce did not verify.');
        }
        
        if (!current_user_can('manage_options')) {
            wp_die('Insufficient permissions.');
        }
        
        // Save settings
        $sync_enabled = isset($_POST["onwebchat_wc_sync_enabled"]) ? true : false;
        $sync_mode = isset($_POST["onwebchat_wc_sync_mode"]) ? sanitize_text_field($_POST["onwebchat_wc_sync_mode"]) : 'short_fallback_full';
        $include_price = isset($_POST["onwebchat_wc_sync_include_price"]) ? true : false;
        
        update_option('onwebchat_wc_sync_enabled', $sync_enabled);
        update_option('onwebchat_wc_sync_mode', $sync_mode);
        update_option('onwebchat_wc_sync_include_price', $include_price);
        
        // Secret is now obtained via authenticated connection, not auto-generated
        
        wp_redirect(admin_url('admin.php?page=onwebchat_settings&tab=woocommerce&wc_saved=1'));
        exit;
    }
}

