<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

/*
Plugin Name: onWebChat - Live Chat & AI Chatbot
Plugin URI: https://www.onwebchat.com/wordpress-live-chat-plugin.php
Description: Empower visitors with real-time human chat and integrated AI chatbots. onWebChat Live Chat delivers instant responses, smoother interactions, and 24/7 availability - improving engagement, satisfaction, and conversions. Includes WooCommerce product sync for AI training.
Author: onWebChat
Version: 3.5.1
Author URI: https://www.onwebchat.com
*/

/**
 * WooCommerce Testing Mode Configuration
 * Set to true for local development (127.0.0.1:81)
 * Set to false for production (www.onwebchat.com)
 */
if (!defined('ONWEBCHAT_WC_TESTING_MODE')) {
    define('ONWEBCHAT_WC_TESTING_MODE', false);
}

/* ---------------------------------------------------- *
* Create Settings Page
* ---------------------------------------------------- */


define('ONWEBCHAT_SMALL_LOGO', plugins_url( 'images/onwebchat-logo.png' , __FILE__ ));
define('ONWEBCHAT_SERVER_URL','https://www.onwebchat.com/get-chatid.php');

// Load WooCommerce sync module if WooCommerce is active
add_action('plugins_loaded', function () {
    if (class_exists('WooCommerce')) {
        require_once __DIR__ . '/includes/woocommerce-sync.php';
    }
});

// add styles
add_action( 'admin_enqueue_scripts', 'register_plugin_styles' );

// call function on hook admin_menu
add_action('admin_menu','onwebchat_setup_menu');

// create login error notice
add_action( 'admin_notices', 'onwebchat_login_error' );

// define the settings
add_action('admin_init','onwebchat_register_setttings');

// handle form submissions early (before any output)
add_action('admin_init', 'onwebchat_handle_all_form_submissions');


/* ---------------------------------------------------- *
* Display onWebChat on footer
* ---------------------------------------------------- */

// add widget plugin to the footer
add_action('wp_footer', 'onwebchat_add_script_at_footer');


/* ----------------------------------------------------- *
* Admin Page registration
* ----------------------------------------------------- */

function onwebchat_setup_menu() {
    add_menu_page( 'onWebChat Settings', 'onWebChat', 'administrator', 'onwebchat_settings', 'onwebchat_init_menu_page', ONWEBCHAT_SMALL_LOGO);
}


/* ------------------------------------------------------ *
* Admin Page Display Function
* ------------------------------------------------------ */

function onwebchat_init_menu_page() {
    // Load the new tabbed settings page
    require_once __DIR__ . '/admin/settings-page.php';
    onwebchat_settings_page();
}

/* ----------------------------------------------------- *
* Admin Page Styles Registration
* ----------------------------------------------------- */

function register_plugin_styles() {
    wp_register_style( 'onwebchat', plugins_url( 'onwebchat/css/onwebchat.css' ) );
    wp_enqueue_style( 'onwebchat' );
}


/* ----------------------------------------------------- *
* Tabs Settings Registration
* ----------------------------------------------------- */

function onwebchat_register_setttings() {

    /******************** Account Tab ************************/
    //* register the Chat Id
    register_setting( 'onwebchat_plugin_option', 'onwebchat_plugin_option');

    //* register the username
    register_setting( 'onwebchat_plugin_option', 'onwebchat_plugin_option_user');

    //* register the hide (checkbox)
    register_setting( 'onwebchat_plugin_option_checkbox', 'onwebchat_plugin_option_hide');

    //TODO api code
    //* register the api code
    register_setting( 'onwebchat_plugin_option', 'onwebchat_plugin_option_api_code');
    
    /******************** WooCommerce Sync Settings ************************/
    register_setting( 'onwebchat_wc_sync', 'onwebchat_wc_sync_enabled');
    register_setting( 'onwebchat_wc_sync', 'onwebchat_wc_sync_mode');
    register_setting( 'onwebchat_wc_sync', 'onwebchat_wc_sync_include_price');
    register_setting( 'onwebchat_wc_sync', 'onwebchat_wc_sync_secret');
    register_setting( 'onwebchat_wc_sync', 'onwebchat_wc_last_bulk_sync');
    register_setting( 'onwebchat_wc_sync', 'onwebchat_wc_excluded_categories');
}


/* ----------------------------------------------------- *
* onWebChat Display Function
* ----------------------------------------------------- */

// print chat widget code
function onwebchat_add_script_at_footer() {

    $options = get_option('onwebchat_plugin_option');
    $chatId = (is_array($options) && isset($options['text_string'])) ? $options['text_string'] : '';
    //$hideWidget = get_option('onwebchat_plugin_option_hide');
    $hideWidget = false;
    
    // If no chat ID is configured, don't output widget code
    if (empty($chatId)) {
        return;
    }

    $widgetCode = "<script type='text/javascript'>var onWebChat={ar:[], set: function(a,b){if (typeof onWebChat_==='undefined'){this.ar.push([a,b]);}else{onWebChat_.set(a,b);}},get:function(a){return(onWebChat_.get(a));},w:(function(){ var ga=document.createElement('script'); ga.type = 'text/javascript';ga.async=1;ga.src='//www.onwebchat.com/clientchat/$chatId';var s=document.getElementsByTagName('script')[0];s.parentNode.insertBefore(ga,s);})()}</script>";

    $apiCode = get_option('onwebchat_plugin_option_api_code');

    $apiCode = str_replace('\\','',$apiCode);

    $apiCode =  "<script type='text/javascript'>$apiCode</script>";

    $widgetCode .= $apiCode;


    //check if user is logged if yes get username, email
    if ( is_user_logged_in() ) {

        global $current_user;
        get_currentuserinfo();

        // get user name
        $onwebchat_user = $current_user->user_login;

        // get user email
        $onwebchat_email = $current_user->user_email;

        //add api info
        if ($onwebchat_user != null && $onwebchat_user != "" && $onwebchat_user != "guest" && $onwebchat_user != "Guest") {
            if ($onwebchat_email != null && $onwebchat_email != ""){
                $widgetCode = $widgetCode."<script type='text/javascript'>onWebChat.set('name','$onwebchat_user');
                onWebChat.set('email','$onwebchat_email'); </script>";
            } else {
                $widgetCode = $widgetCode."<script type='text/javascript'>onWebChat.set('name','$onwebchat_user');</script>";
            }
        }
    }

    $currentPage = substr( strtolower($_SERVER['SERVER_PROTOCOL']), 0, strpos( strtolower($_SERVER['SERVER_PROTOCOL']), "/") );
    $currentPage .= ( empty($_SERVER['HTTPS']) ? NULL : ( ($_SERVER['HTTPS'] == "on") ? "s" : NULL) );
    $currentPage .= "://" . $_SERVER['SERVER_NAME'];
    $currentPage .= ( $_SERVER['SERVER_PORT'] == 80 ? "" : ":".$_SERVER['SERVER_PORT'] );
    $currentPage .= $_SERVER['REQUEST_URI'];

    $pagesSelect = get_option('onwebchat_plugin_option_pages_select');
    $showPages = get_option('onwebchat_plugin_option_show_pages');
    $showPages = explode(' ', $showPages);
    $hidePages = get_option('onwebchat_plugin_option_hide_pages');
    $hidePages = explode(' ', $hidePages);

    $showSelect=true;
    if ($pagesSelect==1){

    } else if ($pagesSelect==2){
        $showSelect=false;
        foreach ($showPages as $page){
            if ($page !== "") {
                if (strpos($currentPage, $page) !== false) {
                    $showSelect = true;
                }
            }
        }
    } else if ($pagesSelect==3){
        $showSelect=true;
        foreach ($hidePages as $page){
            if ($page !== "") {
                if (strpos($currentPage, $page) !== false) {
                    $showSelect = false;
                }
            }
        }
    } else if($pagesSelect == 4) {
        //hide chat widget from all pages
        $hideWidget = true;
    }

    if(!$hideWidget && $showSelect) {
        echo $widgetCode;
    }

}

/************************************************************************
 * display error function
 ***********************************************************************/
function onwebchat_login_error($contition = false) {
    
    

    if($contition) {
        ?>

        <div class="error">
            <p><strong>Invalid credentials!</strong> Please make sure you have entered the correct email and password, <strong>OR</strong> provide a valid Chat ID</p>
        </div>
        <?php
    }
    else {
        //display nothing
    }
}

/************************************************************************
 * Validate Chat Id function
 ***********************************************************************/
function isChatIdValid($input) {
    return preg_match('/^[a-f0-9]{32,40}+[\\/]?+[0-9]{0,2}+[\\/]?+[0-9]{0,2}$/i', $input);
}

/************************************************************************
 * Fetch WooCommerce secret during login
 * Called automatically when user logs in with email/password
 * This way they don't need to re-enter credentials in WooCommerce tab
 ***********************************************************************/
function onwebchat_fetch_wc_secret_on_login($email, $password, $chatId) {
    // Extract key part (before first slash if present)
    $key = explode('/', $chatId)[0];
    
    // Determine endpoint based on testing mode constant
    $endpoint = ONWEBCHAT_WC_TESTING_MODE 
        ? 'http://127.0.0.1:81/api/integrations/woocommerce/secret'
        : 'https://www.onwebchat.com/api/integrations/woocommerce/secret';
    
    // Request secret with authentication
    $response = wp_remote_post($endpoint, array(
        'timeout' => 15,
        'sslverify' => !ONWEBCHAT_WC_TESTING_MODE,
        'headers' => array(
            'Content-Type' => 'application/json',
        ),
        'body' => wp_json_encode(array(
            'email' => $email,
            'password' => $password,
            'site_key' => $key,
        )),
    ));
    
    if (is_wp_error($response)) {
        // Silently fail - user can still connect manually in WooCommerce tab
        error_log('onWebChat: Failed to fetch WC secret on login: ' . $response->get_error_message());
        return;
    }
    
    $status_code = wp_remote_retrieve_response_code($response);
    $response_body = wp_remote_retrieve_body($response);
    $body = json_decode($response_body, true);
    
    if ($status_code >= 200 && $status_code < 300 && isset($body['success']) && $body['success']) {
        // Success! Store the secret
        update_option('onwebchat_wc_sync_secret', $body['secret']);
        error_log('onWebChat: WooCommerce sync connected automatically during login');
    }
    // If it fails, user can still connect manually - no error shown
}

/************************************************************************
 * Handle all form submissions early to avoid blank page on redirect
 * Must run on admin_init before any output is sent
 ***********************************************************************/
function onwebchat_handle_all_form_submissions() {
    // Only run on our settings page
    if (!isset($_GET['page']) || $_GET['page'] !== 'onwebchat_settings') {
        return;
    }
    
    // Load the general tab handlers
    require_once __DIR__ . '/admin/tabs/general.php';
    onwebchat_handle_general_actions();
}

// omit the closing php tag ? >  for avoid issues
